<?php
	if(!isset($title)) {
		$title = "";
	}
	else {
		$title = $title . " - ";
	}

	class Headers {
		var $get = array();
		var $post = array();
		
		function __construct() {
			$this->get = $_GET;
			$this->post = $_POST;
		}
		
		function GET($name) {
			if(isset($this->get[$name])) return $this->get[$name];
			return false;
		}
		
		function POST($name) {
			if(isset($this->post[$name])) return $this->post[$name];
			return false;
		}
		
		function PostField($name) {
			$a = $this->POST($name);
			if($a === false) return '';
			return $a;
		}
		
		function GetField($name) {
			$a = $this->GET($name);
			if($a === false) return '';
			return $a;
		}
	}

	$headers = new Headers();
    
    $db = json_decode(file_get_contents("data/main.db"), true);
    
	$websiteName = $db['WebsiteName'];
?>
<!DOCTYPE HTML>
<html>
	<head>
		<title><?php echo $title; ?>Web Studio</title>

		<link rel="stylesheet" type="text/css" href="resources/css/bootstrap.min.css">
		<link rel="stylesheet" type="text/css" href="resources/css/main.css">

		<script src="resources/js/jquery.min.js"></script>
		<script src="resources/js/bootstrap.min.js"></script>
	</head>
	<body>
		<div class="header">
			<div class="container-fluid">
				<div class="col-xs-7">
					<h2><?php echo $db['HeaderText']; ?></h2>
				</div>
				<div class="col-xs-5">
					<div style="text-align: right;" class="headernav">
						<a href="./">Home</a>
						<a href="tools.php">Tools</a>
						<?php if($db['ShowAdminButton']) { ?><a href="admin/">Admin</a><?php } ?>
					</div>
				</div>
			</div>
		</div>

		<div class="container-fluid">
			<div class="col-md-3">
				<?php
					if(file_exists("structures/nav.php")) {
						require "structures/nav.php";
					}
				?>
			</div>
			<div class="col-md-9">